<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Site extends Model 
{

    protected $table = 'sites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function owners()
    {
        return $this->hasMany('Data');
    }

    public function operation()
    {
        return $this->hasOne('Operation');
    }

    public function country()
    {
        return $this->belongsTo('Country');
    }

    public function zones()
    {
        return $this->hasMany('Zone');
    }

    public function perimetres()
    {
        return $this->hasMany('Perimetre');
    }

    public function controles()
    {
        return $this->belongsToMany('Controle');
    }

    public function planifications()
    {
        return $this->hasMany('Planification');
    }

    public function users()
    {
        return $this->belongsToMany('User');
    }

}